"use strict";
//
// Copyright 2021 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
class ReceiptCredential extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.ReceiptCredential_CheckValidContents);
    }
    getReceiptExpirationTime() {
        return Native.ReceiptCredential_GetReceiptExpirationTime(this.contents);
    }
    getReceiptLevel() {
        return Native.ReceiptCredential_GetReceiptLevel(this.contents).readBigUInt64BE();
    }
}
exports.default = ReceiptCredential;
//# sourceMappingURL=ReceiptCredential.js.map